<?php

function CreateRandomString($minlength, $maxlength) {
	//Zufallsstring erzeugen
	$ticketDate = date("Ymd");
	$legalCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	mt_srand();
	$rdLoops = mt_rand($minlength, $maxlength);
	$randomString = "";
	for ($i=1; $i<= $rdLoops; $i++) {
		mt_srand();
		$posCharacter = mt_rand(0,26);
		$randomString .= substr($legalCharacters, $posCharacter,1);
	}
	
	$actualDate = date("Ymd");
	$ticket = $actualDate.":".$randomString;
	
	//Ergebnis in Datei schreiben
	require("tickets.php");
	array_push($tickets, $ticket);
	$ticketString = "";
	for ($i=0; $i<count($tickets); $i++) {
		$ticketString .= "\"".$tickets[$i]."\"";
		if ($i<(count($tickets)-1)) {
			$ticketString .= ",";
		}
	}
	$fd = fopen("tickets.php", "w+");
	rewind($fd);
	$content = "<?php \$tickets = array(".$ticketString."); ?>";
	fputs($fd,$content);
	fclose($fd);	
	return $randomString;
}

function CreateImageTicket($randomString) {
	header("Content-type: image/png");
	$im     = imagecreatefrompng("images/ticket.png");
	$black = imagecolorallocate($im, 10, 0, 0);
	$px     = (imagesx($im) - 9 * strlen($randomString)) / 2;
	imagestring($im, 7, $px, 1, $randomString, $black);
	imagepng($im);
	imagedestroy($im);
}

function DeleteOldTickets() {
	$actualDate = date("Ymd");
	require("tickets.php");
	$ticketString = "";
	for ($i=0; $i<count($tickets); $i++) {
		$ticketDate = explode(":", $tickets[$i]);
		if ($ticketDate[0] == $actualDate) {
			$ticketString .= "\"".$tickets[$i]."\"";
			if ($i<(count($tickets)-1)) {
				$ticketString .= ",";
			}
		}
	}
	$stringLength = strlen($ticketString);
	$lastChar = substr($ticketString, $stringLength-1,1);
	if ($lastChar == ",") {
		$ticketString = substr($ticketString,0,$stringLength-1);
	}
	$content = "<?php \$tickets = array(".$ticketString."); ?>";
	$fd = fopen("tickets.php", "w+");
	rewind($fd);
	fputs($fd,$content);
	fclose($fd);
}

DeleteOldTickets();
$randomString = CreateRandomString(6, 6);
CreateImageTicket($randomString);

?>